/*

Convert To: MacroScript File


	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

 
This script enables all surface conversions through Macroscripts.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 

*/


MacroScript Collapse_Stack 
	ButtonText:~COLLAPSE_STACK_BUTTONTEXT~ 
	Category:~COLLAPSE_STACK_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~COLLAPSE_STACK_TOOLTIP~ 
	-- Needs Icon
	--Icon:#("Max_edit_modifiers",1)
(	
	
	On isEnabled return Try(Filters.Are_Modifiers_Applied())Catch()
	On isVisible return Try(Filters.Are_Modifiers_Applied())Catch() 
	On Execute Do	
	(
		Undo on 
		(
			if SubObjectLevel == undefined then Max Modify Mode
			For obj in selection do
			(
				Try(CollapseStack obj)Catch()
			)		
		) 
	
	)
	
)


MacroScript Modify_Mode 
	ButtonText:~MODIFY_MODE_BUTTONTEXT~ 
	Category:~MODIFY_MODE_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~MODIFY_MODE_TOOLTIP~ 
	-- Needs Icon
	--Icon:#("Max_edit_modifiers",1)
(	
	
	On isEnabled return (Try(getCommandPanelTaskMode() != #modify)Catch())
	On isVisible return (Try(getCommandPanelTaskMode() != #modify)Catch()) 
	On Execute Do	
	(
		Max Modify Mode 
	
	)
	
)
MacroScript Create_Mode 
	ButtonText:~CREATE_MODE_BUTTONTEXT~ 
	Category:~CREATE_MODE_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~CREATE_MODE_TOOLTIP~ 
	-- Needs Icon
	--Icon:#("Max_edit_modifiers",1)
(	
	
	On isEnabled return (Try(getCommandPanelTaskMode() != #create)Catch())
	On isVisible return (Try(getCommandPanelTaskMode() != #create)Catch()) 
	On Execute Do	
	(
		Max Create Mode 
	
	)
	
)


MacroScript Convert_to_Mesh 
	ButtonText:~CONVERT_TO_MESH_BUTTONTEXT~ 
	Category:~CONVERT_TO_MESH_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~CONVERT_TO_MESH_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",1)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] Mesh)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] Mesh)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		for obj in selection do
		(
			Try(ConvertToMesh obj)Catch() 
		)
		ResumeEditing()
		Max modify mode
	)
)

MacroScript Convert_to_Patch 
	ButtonText:~CONVERT_TO_PATCH_BUTTONTEXT~ 
	Category:~CONVERT_TO_PATCH_CATEGORY~  
	internalCategory:"Modifier Stack"  
	Tooltip:~CONVERT_TO_PATCH_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",2)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] Editable_Patch)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] Editable_Patch)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		for obj in selection do
		(
			Try(ConvertTo obj Editable_Patch)Catch() 
		)
		ResumeEditing()
		Max modify mode
	)
)

MacroScript Convert_to_Spline 
	ButtonText:~CONVERT_TO_SPLINE_BUTTONTEXT~ 
	Category:~CONVERT_TO_SPLINE_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~CONVERT_TO_SPLINE_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",11)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] SplineShape)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] SplineShape)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		for obj in selection do
		(
			Try(ConvertToSplineShape obj)Catch() 
		)
		ResumeEditing()
		Max modify mode
	)
)

MacroScript Convert_to_NURBS 
	ButtonText:~CONVERT_TO_NURBS_BUTTONTEXT~ 
	Category:~CONVERT_TO_NURBS_CATEGORY~  
	internalCategory:"Modifier Stack"  
	Tooltip:~CONVERT_TO_NURBS_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",16)
(	
	-- only check the first item in the selection array. Fast but not very robust.
	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] NURBSSurface)Catch())
	-- only check the first item in the selection array. Fast but not very robust.
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] NURBSSurface)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		-- Ensure each item can be converted before attempting it.
		for obj in selection where (CanConvertTo obj NurbsSurface) do
		(
			ConvertToNURBSSurface obj 
		)
		ResumeEditing()
		Max modify mode
	)
)

MacroScript Convert_to_Poly
	ButtonText:~CONVERT_TO_POLY_BUTTONTEXT~ 
	Category:~CONVERT_TO_POLY_CATEGORY~  
	internalCategory:"Modifier Stack"  
	Tooltip:~CONVERT_TO_POLY_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",16)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] Editable_Poly)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] Editable_Poly)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		Try(
		for obj in selection do
		(
			Try(ConvertTo obj Editable_Poly)Catch() 
		)
		Max modify mode
		)
		Catch() 
		ResumeEditing()
	)
)

MacroScript Convert_to_deformable_gPoly
	ButtonText:~CONVERT_TO_DEFORMABLE_GPOLY_BUTTONTEXT~ 
	Category:~CONVERT_TO_DEFORMABLE_GPOLY_CATEGORY~  
	internalCategory:"Modifier Stack"  
	Tooltip:~CONVERT_TO_DEFORMABLE_GPOLY_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",16)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] deformable_gPoly)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] deformable_gPoly)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		Try(
		for obj in selection do
		(
			Try(ConvertTo obj deformable_gPoly) Catch() 
		)
		Max modify mode
		)
		Catch() 
		ResumeEditing()
	)
)

-- Added by NH as part of Grab bag feature.  Provide an Action item for Show End Result in modifier stack
MacroScript Show_End_Result_Toggle
            category:~SHOW_END_RESULT_TOGGLE_CATEGORY~ 
            internalCategory:"Modifier Stack" 
            ButtonText:~SHOW_END_RESULT_TOGGLE_BUTTONTEXT~
            tooltip:~SHOW_END_RESULT_TOGGLE_TOOLTIP~ 

(
     on execute do showEndResult = not showEndResult -- action to execute - toggle the setting
     on isEnabled return true -- greyed out if false
     on isChecked return showEndResult -- checked if true
     on isVisible return true -- visible if true
)

-- Added by NH as part of Maintain Custom Attributes on Stack Collapse feature.  Provide an Action item for togglng the Survive flag state
MacroScript Maintain_Custom_Attributes_On_StackCollapse_Toggle
            category:~MAINTAIN_CUSTOM_ATTRIBUTES_ON_STACKCOLLAPSE_TOGGLE_CATEGORY~ 
            internalCategory:"Modifier Stack" 
            ButtonText:~MAINTAIN_CUSTOM_ATTRIBUTES_ON_STACKCOLLAPSE_TOGGLE_BUTTONTEXT~
            tooltip:~MAINTAIN_CUSTOM_ATTRIBUTES_ON_STACKCOLLAPSE_TOGGLE_TOOLTIP~ 

(
     on execute do custattribCollapsemanager.surviveState = not custattribCollapsemanager.surviveState -- action to execute - toggle the setting
     on isEnabled return true -- greyed out if false
     on isChecked return custattribCollapsemanager.surviveState -- checked if true
     on isVisible return true -- visible if true
)

macroScript ProjectioModToggleNodeVisibility
	category:~PROJECTIOMODTOGGLENODEVISIBILITY_CATEGORY~ 
	internalCategory:"Projection Modifier" 
	tooltip:~PROJECTIOMODTOGGLENODEVISIBILITY_TOOLTIP~
	ButtonText:~PROJECTIOMODTOGGLENODEVISIBILITY_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try (
			if selection.Count > 0 do (
				pmod = FindPMod $
				if pmod != undefined do (
					pmodi = pmod.projectionModOps
					pmodi.setGeomSelNodesVisibility (not pmodi.getGeomSelNodesVisibility())
				)
			)
		)
		Catch()
	)

	on isEnabled do
	(
		selection.Count > 0
	)
)

macroScript ProjectioModDisplayToggleEnable
	category:~PROJECTIOMODDISPLAYTOGGLEENABLE_CATEGORY~ 
	internalCategory:"Projection Modifier" 
	tooltip:~PROJECTIOMODDISPLAYTOGGLEENABLE_TOOLTIP~
	ButtonText:~PROJECTIOMODDISPLAYTOGGLEENABLE_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try (
			if selection.Count > 0 do (
				local pmod = FindPMod $
				if pmod != undefined do (
					pmod.displayToggleEnable = (not pmod.displayToggleEnable)
				)
			)
		)
		Catch()
	)

	on isEnabled do
	(
		selection.Count > 0
	)
)

macroScript ProjectioModDisplayToggleMode
	category:~PROJECTIOMODDISPLAYTOGGLEMODE_CATEGORY~ 
	internalCategory:"Projection Modifier" 
	tooltip:~PROJECTIOMODDISPLAYTOGGLEMODE_TOOLTIP~
	ButtonText:~PROJECTIOMODDISPLAYTOGGLEMODE_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try (
			if selection.Count > 0 do (
				local pmod = FindPMod $
				if pmod != undefined do (
					local pmodMode = pmod.displayToggleMode
					if (pmodMode==1) then
					     pmod.displayToggleMode = 2
					else pmod.displayToggleMode = 1
				)
			)
		)
		Catch()
	)

	on isEnabled do
	(
		selection.Count > 0
	)
)

